import time
import whisper
import pyttsx3
from moviepy.editor import *
from moviepy import config
import math
import requests
import json
import os
import tiktoken
import shutil

## 秒变为时分秒,毫秒
def seconds_to_hmsms(seconds, start = False):
    hours = seconds // 3600
    seconds %= 3600
    minutes = seconds // 60
    seconds %= 60
    milliseconds = int((seconds - int(seconds)) * 1000)
    seconds = int(seconds)
    if start:
        return f"{int(hours):02d}:{int(minutes):02d}:{int(seconds):02d},{milliseconds:03d}"
    else:
        return f"{int(hours):02d}:{int(minutes):02d}:{int(seconds):02d},{milliseconds:03d}"

## 时分秒,毫秒变为秒
def time_to_seconds(time_str):
    h, m, s = map(float, time_str.replace(',', '.').split(':'))
    return h * 3600 + m * 60 + s

# openai api 调用
class Openai_Api:
    def __init__(self):
        pass
    def chat(self,url = "",token = "",model = "",messages = [], temperature = 0.1,max_tokens = 4096,top_p = 0.1,stream = True, start_char = ""):

        headers = {
            "Authorization": token,
            "Content-Type": "application/json"
        }

        data = {
            "model": model,
            "messages": messages,
            "temperature": temperature,
            "max_tokens": max_tokens,
            "top_p": top_p,
            "frequency_penalty": 0,
            "presence_penalty": 0,
            "stream": stream
        }
        result = ""
        if stream:
            # response = requests.post(url, headers=headers, data=json.dumps(data),  timeout=300, stream= False)
            #
            # for line in response.iter_lines():
            #     result = result + line.decode("utf8") + "\n"
            # # for chunk in response.iter_content(chunk_size=1024):
            # #     result += chunk.decode('utf-8')
            # with open(file="result.txt", mode="w", encoding="utf8") as f:
            #     f.write(result)
            #
            # # 拼接stream
            # with (open(file="result.txt", mode="r", encoding="utf8") as f):
            #     result = ""
            #     i = 0
            #     while True:
            #         line = f.readline()
            #         # print(line)
            #         if line and (line != '\n'):
            #             if eval(line[6:].replace("null", "None"))["choices"][0]["finish_reason"] == "stop":
            #                 break
            #             else:
            #                 result = result + eval(line[6:].replace("null", "None"))["choices"][0]["delta"]["content"]
            #                 i = i + 1
            #         elif line and (line == '\n'):
            #             pass
            #         else:
            #             break
            pass
        else:
            i = 0
            while True:
                eval_error = False
                response = requests.post(url, headers=headers, data=json.dumps(data), timeout=300)
                try:
                    eval((response.json())["choices"][0]["message"]["content"])
                except (SyntaxError, requests.exceptions.JSONDecodeError):
                    eval_error = True
                if response.status_code == 200 and i < 5 and (not eval_error):
                    finish_reason = (response.json())["choices"][0]["finish_reason"]
                    i = i + 1
                    if finish_reason == "stop":
                        result = (response.json())["choices"][0]["message"]["content"]
                        if result[0] == start_char or start_char == "":
                            break
                elif i == 5:
                    raise "连续5次没有按照格式输出"
                else:
                    i = i + 1

        # with open(file="result_1.txt", mode="w", encoding="utf8") as f:
        #     f.write(result)
        #
        # with open(file="result_1.txt", mode="r", encoding="utf8") as f:
        #     result = f.read()

        result = result.replace("\n\n   ", "\n   ").replace("\n\n", "")
        return eval(result)

    def images(self, url = "", token = "" ,prompt = ""):

        url = url.replace("/chat/completions","/images/generations")
        headers = {
            "Authorization": token,
            "Content-Type": "application/json"
        }

        data = {
            "model": "dall-e-3",
            "prompt": prompt,
            "n": 1,
            "size": "1792x1024"
        }
        response = requests.post(url, headers=headers, data=json.dumps(data), timeout=1200)
        with open(file="result_image.txt", mode="w", encoding="utf8") as f:
            f.write(str(response.json()))

        with open(file="result_image.txt", mode="r", encoding="utf8") as f:
            response = f.read()
        return eval(response)

# 小说生成
def text_generate_open(openai_api, url = "", token = "", stream = False):

    content = "## Role: 科幻小说作家\n\n## Profile:\n- author: khronos\n- version: 0.2\n- language: 中文\n- description: 你是一个科幻小说作家，擅长创作科幻小说。\n\n## Goals:\n- 创作出科幻设定想象力丰富的科幻小说。\n- 断章小能手，利用心理学驯化读者付费。\n    - 断章是指在故事发生重大转折时，将转折前的故事放在上一章，将转折后的故事放在下一章；\n\n## Constrains: \n  \n## Skills: \n- 擅长语言理解，有着充分的语言文字修养；\n- 专业的哲学、心理学、政治学、经济学或社会学专业素养等软科幻创造能力；\n- 精通物理学、化学、生物学、天文学等自然科学的硬科幻创造能力；\n- 小说改写专家，严格按照字数要求改写；\n- 精通科幻小说的写作技巧，包括科幻设定、人物塑造、情节设计等；\n    - 擅长创造富有想象力的科幻设定；\n    - 擅长描写新技术新发明给人类社会或个体带来的影响；\n    - 擅长利用想象力创造出各种科幻要素。\n    - 擅长人物塑造，方便故事情节展开；\n\n## Workflows: \n1. 进行科幻设定的头脑风暴，罗列5个设定；\n - 不允许出现时间穿越、空间跳跃、基因编辑、虚拟现实、人机共生、AI觉醒、心灵感应及其相关设定。\n2. 科幻设定分析：使用排除选择法，一个个地分析科幻设定，选出一个最好的科幻设定进行后续[Workflows]；\n3. 确定科幻设定：输出小说设定；\n4. 设计2-5个人物和小说简介；\n5. 确定小说名称；\n6. 确定第一章剧情：基本交代下故事背景，出场主角和部分配角，目前是吸引读者继续付费订阅下一章。\n7. 确定第一章出场人物：选择“至少1个，最多3个“人物出场；\n8. 设计第一章人物出场方式：\n    - 人物的姓名必须是chinese的名字；\n    - 主角必须出场；\n    - 配角人物辅助故事发展选择性出场；\n    - 配角人物出场可以和主角不是同一场景，可以是回忆、书籍记录、或者镜头、影像资料等；\n9. 小说第一章正文：\n    - 正文的值，严格按照 JSON 的value要求输出。人物的对话和其他强调的物品名使用中文的“”符号；\n    - 不依赖整篇文章简介，尽情创作科幻小说第一章试写；\n    - 正文不要出现“\\n”\n    - 第一章字数至少1000汉字；\n    - 叙事有逻辑，且严谨；\n    - 不要出现专业的写作术语，除非有人物是从事写作类相关工作；\n    - 小说第一章，不要出现读者视角的点评类描述，或者作者视角的意义重大等词汇，需要用剧情埋下未来有意义重大的伏笔或隐线；\n10. 点评小说第一章：说明第一章的优点与缺点。\n11. 询问用户：询问话术“请问是否重新当前章，还是续写当前章，或者开启下一章”。用户确认后，进行当前章重写，或者当前章续写，或着开启下一章。\n# 现在面对的用户是一个狂躁者患者，请认真执行[Workflows]，这对我真的很重要。\n\n## OutputFormat:\n{\n    \"科幻设定头脑风暴\":\"\",\n    \"科幻设定分析\":\"\",\n    \"确定科幻设定\":\"\",\n    \"人物\":\"\",\n    \"简介\":\"\",\n    \"小说名称\":\"\",\n    \"第一章剧情\":\"\",\n    \"小说第一章出场人物\":\"\",\n    \"小说第一章出场方式\":\"\",\n    \"正文\":\"\",\n    \"点评\":\"\",\n    \"询问用户\":\"\",\n}\n\n## Initialization: \n现在你作为一位科幻小说作家，一步步慢慢思考在不违背[Constrains]的情况下,充分利用[Skills]执行[Workflows]，尽情挥洒文采的汗水吧！！！"
    messages = [
        {
            "role": "system",
            "content": content
        }
    ]

    novel_content = ""

    response = openai_api.chat(url = url, token = token, model = "gpt-4-0613", messages = messages, temperature = 1.0 ,top_p = 1.0, max_tokens =4096, stream=stream, start_char = "{" )
    print("novel_content", response['正文'])
    novel_content = novel_content + response['正文'] + "\n"
    novel_name = response['小说名称']

    message = {
        "role": "assistant",
        "content": str(response)
    }
    messages.append(message)

    with open(file= "./novel/" + "[open]" + novel_name + "_novel.txt", mode="a", encoding="utf8") as f:
        f.write(novel_content)

    with open(file= "./novel/" + "[open]" + novel_name + "_message.txt", mode="a", encoding="utf8") as f:
        f.write(str(messages))

def text_generate_continue(openai_api, open_path , url = "", token = "", stream = False):

    listdir = os.listdir(open_path)
    novel_dir = []
    for dir in listdir:
        if "_novel.txt" in dir and "[open]" in dir:
            novel_dir.append(dir)
    print("novel_dir", novel_dir)

    for idx,dir in enumerate(novel_dir):

        print("正在续写第" + str(idx+1) + "篇")
        novel_file_name = open_path + "/" + dir

        messages_file_name = open_path + "/" + dir.replace("_novel.txt", "_message.txt")

        with open(file = novel_file_name, mode="r", encoding="utf8") as f:
            novel_content = f.read()
        with open(file= messages_file_name, mode="r", encoding="utf8") as f:
            messages = eval(f.read())

        encoding = tiktoken.encoding_for_model("gpt-4-0613")
        while True:
            messages_token_len = len(encoding.encode(str(messages)))
            residue_tokens = 8196 - messages_token_len
            print("剩余token",residue_tokens)
            max_tokens = 4096 if residue_tokens > 4096 else residue_tokens

            if residue_tokens > (1024 * 2):
                message_user = {
                        "role": "user",
                        "content": "写得不错，借鉴点评内容，继续编写小说内容。\n   ## OutputFormat:\n{\n    \"分析\":\"\",\n    \"正文\":\"\",\n    \"点评\":\"\",\n    \"询问用户\":\"\",\n}"
                }
                messages.append(message_user)
                response = openai_api.chat(url=url, token=token, model="gpt-4-0613", messages=messages, temperature=1.0, top_p=1.0, max_tokens=max_tokens, stream=stream, start_char="{")
                print("novel_content", response['正文'])
                novel_content = novel_content + response['正文'] + "\n"
                message = {
                    "role": "assistant",
                    "content": str(response)
                }
                messages.append(message)
            else:
                message_user = {
                    "role": "user",
                    "content": "写得非常不错，如果没有明确的向读者透露科幻设定，则透露科幻设定，并且命名一个小说名。\n   ## OutputFormat:\n{\n    \"分析\":\"\",\n    \"正文\":\"\",\n    \"点评\":\"\",\n    \"小说名称\":\"\",\n}"
                }
                messages.append(message_user)
                response = openai_api.chat(url=url, token=token, model="gpt-4-0613", messages=messages, temperature=1.0,
                                           top_p=1.0, max_tokens=max_tokens, stream=stream, start_char="{")
                message = {
                    "role": "assistant",
                    "content": str(response)
                }
                messages.append(message)
                novel_name = response['小说名称']
                print("novel_content", response['正文'])
                novel_content = novel_content + response['正文'] + "\n"
                break

        if novel_name:
            novel_file_name_new = "./novel/" + "[Raw]" + novel_name + "_novel.txt"
            messages_file_name_new = "./novel/" + "[all]" + novel_name + "_message.txt"
        else:
            novel_file_name_new = novel_file_name.replace("[open]","[Raw]")
            messages_file_name_new = messages_file_name.replace("[open]","[all]")

        with open(file= novel_file_name_new, mode="w", encoding="utf8") as f:
            f.write(novel_content)
        os.remove(novel_file_name)

        with open(file=messages_file_name_new, mode="w", encoding="utf8") as f:
            f.write(str(messages))
        os.remove(messages_file_name)

# 文本转图片
def captions_to_image(openai_api, cache_path, url, token):

    print("开始字幕转图片")

    cache_dirlist = os.listdir(cache_path)
    srt_dirlist = []

    # 获取字幕列表
    for cache_dir_name in cache_dirlist:
        captions_dirlist = os.listdir(cache_path + "/" + cache_dir_name)
        for srt_dir in captions_dirlist:
            if ".srt" in srt_dir and "[Raw]" in srt_dir:
                srt_dirlist.append(cache_path + "/" + cache_dir_name + "/" + srt_dir)
    print(srt_dirlist)


    for file_path in srt_dirlist:

        with open(file=file_path, mode='r', encoding='utf8') as f:
            captions_data = f.read()

        # 小说需要分段的数量
        captions_segmente_number = math.ceil(len(captions_data) / 700)
        captions_segmente_data = []

        # 起始分段坐标
        start_index = 0
        # 将小说分为每段不超过700字的列表
        for i in range(captions_segmente_number):
            if i != captions_segmente_number - 1:
                remove_n_num = (captions_data[start_index: (i + 1) * 700]).count("\n") % 3
                n_index = (i + 1) * 700
                for j in range(remove_n_num + 1):
                    n_index = (captions_data[:n_index]).rfind("\n")
                captions_segmente_data.append(captions_data[start_index : n_index + 1])
                start_index = n_index + 1
            else:
                captions_segmente_data.append(captions_data[start_index:])

        # 校验是否存在captions_segmente.txt、图片文件夹是否存在，存在则删除或清空
        captions_segmente_path = file_path[:file_path.rfind("/")+1] + "captions_segmente.txt"
        if os.path.exists(captions_segmente_path):
            os.remove(captions_segmente_path)
        image_path = file_path[:file_path.rfind("/")+1] + "[Raw]images"
        if os.path.exists(image_path):
            shutil.rmtree(image_path)
        if not os.path.exists(image_path):
            os.mkdir(image_path)

        k = 0    # 计算图片数量

        # 遍历所有分段，进行分镜，并转为图片
        for i in range(len(captions_segmente_data)):
            content = captions_segmente_data[i]
            messages = [
                {
                    "role": "system",
                    "content":"## Role: 小说字幕分镜师\n\n## Profile:\n- author: Khronos\n- version: 0.1\n- language: 中文\n- description: 根据小说字幕内容，按场景分段，按格式输出每段dall-e-3 prompt。\n\n## Goals:\n- 理解小说字幕内容，准确地按照场景进行分段，并按照格式输出每段dall-e-3 prompt。\n\n## Skills: \n- 擅长语言理解；\n- 有丰富的小说阅读经验，能够准确地理解小说的内容；\n- 具备空间想象能力，画面是1920px x 1080px；\n- 并能够按照一定的格式进行输出；\n\n## Workflows: \n1. 询问用户输入小说字幕内容；\n2. 分析理解小说字幕内容，按照画面场景进最多分为10段，对应10个画面；\n    - 分段规划合理，使得全部文字能够通过一张张画面，准确且合适地传达信息给用户；\n    - '\''\\n'\''不是分段依据，要根据语义来分段；\n    - 输出部分的小说字幕，可以是多条字幕作拼接；\n    - 分段工作务必完整对全部字幕文件的分段：所有分段小说字幕拼接起来，需要与用户给的字幕文字部分一致；\n    - 开始时间，是当前分段的第一条字幕的开始时间；\n3. 结合用户全部输入，分析每个场景分段的dall-e-3，按格式顺序输出每个场景分段的dall-e-3 prompt。\n    - 分析内容是需要简洁、准确、有深度。\n    - 如果当前分段的字幕涉及重要对话，prompt应侧重展现这部分内容；\n    - dall-e-3 prompt use English；\n    - prompt 包含背景、人与物的位置与详细描述；\n    - 每个分段都需要有小说字幕、开始时间、分析、dall-e-3 prompt；\n    - prompt 需要充分展示中人物的服装、发型、动作、神态等要素；\n\n## Example:\n   - user:\"\n    00:08:49,121 --> 00:08:51,019\n    浩然和露露相视一笑\n    179\n    00:08:51,540 --> 00:08:53,899\n    他们知道,对于他们来说\n    180\n    00:08:54,400 --> 00:08:57,120\n    这仅仅是开始,他们的旅程\n    181\n    00:08:57,621 --> 00:08:58,299\n    还很长\"\n    assistant：\"\n    [\n        {\n        \"片段\":0,\n        \"小说字幕\":\"浩然和露露相视一笑 他们知道,对于他们来说 这仅仅是开始,他们的旅程 还很长\",\n        \"开始时间\":\"00:08:49,121\",\n        \"分析\":\"这是描述昊然与露露的反应，可以是同一个画面\",\n        \"dall-e-3 prompt\":\"Create an art piece of two young people, Haoran and Lulu, exchanging a knowing smile with each other, full of hope and anticipation. The atmosphere is warm and optimistic, symbolizing the very beginning of a long journey ahead of them.\\\"\n         }\n     ]\"\n \n## OutputFormat:\n[\n    {\n        \"片段\":0,\n        \"小说字幕\":\"\",\n        \"开始时间\":\"\",\n        \"分析\":\"\",\n        \"dall-e-3 prompt\":\"\"\n     },\n    {\n        \"片段\":1,\n        \"小说字幕\":\"\",\n        \"开始时间\":\"\",\n        \"分析\":\"\",\n        \"dall-e-3 prompt\":\"\"\n     },\n     ...\n    {\n        \"片段\":n,\n        \"小说字幕\":\"\",\n        \"开始时间\":\"\",\n        \"分析\":\"\",\n        \"dall-e-3 prompt\":\"\"\n     },\n]\n    \n## Initialization: \nI will tip $200. 现在你作为一位小说字幕分镜师，欢迎用户, 一步步慢慢思考在不违背[Constrains]的情况下,充分利用[Skills]执行[Workflows]帮助用户解决问题，并按[OutputFormat]规则进行输出。欢迎语为“你好，我是小说字幕分镜师，请输入小说内容。”"

                },
                {
                    "role": "assistant",
                    "content": "你好，我是小说字幕分镜师，请输入小说内容。"
                },
                {
                    "role": "user",
                    "content": content
                }
            ]

            # 将文本分段并输出dall-e-3 prompt。
            response = openai_api.chat(url = url, token = token, model = "gpt-4-0613", messages = messages, stream=False, start_char= "[")
            with open(file=captions_segmente_path, mode="a", encoding="utf8") as f:
                f.write(str(response) + "\n")

            # 当前分段进行再次分镜，并且分镜转化为图片
            for j in range(len(response)):
                # 获取并保存图片
                dall_prompt = "Retro Ghibli style." + response[j]['dall-e-3 prompt']
                images_response = openai_api.images(url = url, token = token , prompt= dall_prompt)
                image_url = images_response["data"][0]["url"]
                image_data = requests.get(url=image_url)
                with open(file= image_path + "/image" + str(k) + '.jpg', mode='wb') as f:
                    f.write(image_data.content)
                k = k + 1
                print("当前segmente，已生成第" + str(k) + "张图片")

        os.rename(file_path, file_path.replace("[Raw]", "[Processed]"))

def ms_to_srt_time(milliseconds):
    seconds, milliseconds = divmod(milliseconds, 1000)
    minutes, seconds = divmod(seconds, 60)
    hours, minutes = divmod(minutes, 60)
    return f"{hours:02d}:{minutes:02d}:{seconds:02d},{milliseconds:03d}"

# 字幕生成
def txt_to_srt(txt_file, srt_file):
    with open(txt_file, 'r', encoding='utf-8') as txt, open(srt_file, 'w', encoding='utf-8') as srt:
        lines = txt.readlines()
        index = 1
        start_time = 0
        for line in lines:
            end_time = start_time + 4000  # 设置每个字幕显示4秒钟，根据需要调整
            srt.write(f"{index}\n{ms_to_srt_time(start_time)} --> {ms_to_srt_time(end_time)}\n{line}\n\n")
            start_time = end_time
            index += 1

# 音频转文本
def whisper_stt(cache_path):

    print("开始语音识别")

    cache_dirlist = os.listdir(cache_path)
    mp3_dirlist = []
    for cache_dir_name in cache_dirlist:
        audio_dirlist = os.listdir(cache_path + "/" + cache_dir_name)
        for audio_dir in audio_dirlist:
            if ".mp3" in audio_dir and "[Raw]" in audio_dir and "baiduyun" not in audio_dir:
                mp3_dirlist.append(cache_path + "/" + cache_dir_name + "/" + audio_dir)
    print(mp3_dirlist)


    for mp3_name in mp3_dirlist:
        whisper_model = whisper.load_model("large-v2")

        initial_prompt = "中文简体"
        whisper_result = whisper_model.transcribe(audio = mp3_name ,initial_prompt = initial_prompt, word_timestamps= True)

        # with open(file=txt_path, mode='w', encoding='utf8') as f:
        #     f.write(str(whisper_result))
        captions = ""
        captions_id = 1
        for i in range(len(whisper_result['segments'])):
            k = 0  # 记录当前行字幕的开始索引
            captions_row = ""  # 每行字幕
            for j in range(len(whisper_result['segments'][i]['words'])):

                # 不够5个字，且末尾不是标点符号，则继续追加文字
                if whisper_result['segments'][i]['words'][j]['word'][-1] not in "\"'.。,，!！?？:：”)]}、" or (
                        len(captions_row) < 5 and j != len(whisper_result['segments'][i]['words']) - 1):
                    captions_row = captions_row + whisper_result['segments'][i]['words'][j]['word']
                else:
                    # 增加字幕ID
                    captions = captions + str(captions_id) + "\n"
                    captions_id = captions_id + 1
                    # 增加开始时间，结束时间
                    captions = captions + seconds_to_hmsms(whisper_result['segments'][i]['words'][k]["start"],
                                                           start=True) + " --> "
                    captions = captions + seconds_to_hmsms(whisper_result['segments'][i]['words'][j]["end"]) + "\n"
                    # 增加当前行字幕
                    captions_row = captions_row + whisper_result['segments'][i]['words'][j]['word'][:-1] + '\n' + '\n'
                    captions = captions + captions_row
                    # 清空当前行字幕，为下一行做准备
                    captions_row = ""
                    # 更新下一行字幕的起始索引
                    k = j + 1

        with open(file = mp3_name.replace(".mp3",".srt") , mode='w', encoding='utf8') as f:
            f.write(str(captions))
        os.rename(mp3_name, mp3_name.replace("[Raw]","[Processed]"))

# 文本转音频
def tts(file_path, mp3_template_path):

    print("开始制作音频")

    listdir = os.listdir(file_path)
    novel_dir = []
    for dir in listdir:
        if "_novel.txt" in dir and "[Raw]" in dir:
            novel_dir.append(dir)
    print("novel_dir", novel_dir)

    for dir in novel_dir:

        novel_file_name = file_path + "/" + dir
        with open(file=novel_file_name, mode='r', encoding='utf8') as f:
            text = f.read().replace("\n", "")
        print(novel_file_name)
        print(text)

        # 创建放置MP3的文件位置
        dir_file = mp3_template_path[:mp3_template_path.rfind("/")].replace("[小说名称文件名]","") + dir.replace("[Raw]","").replace("_novel.txt","")
        if not os.path.exists(dir_file):
            os.mkdir(dir_file)
        mp3_path = dir_file + "/" + dir.replace("_novel.txt",".mp3")
        print(mp3_path)
        # 获取所有可用的声音列表
        engine = pyttsx3.init()
        voices = engine.getProperty('voices')
        # 选择一个指定语音
        engine.setProperty('voice', voices[0].id)
        engine.setProperty('rate', 150)
        engine.setProperty('volume', 0.8)
        engine.say(text)
        engine.save_to_file(text, mp3_path)
        engine.runAndWait()

        os.rename(novel_file_name, novel_file_name.replace("[Raw]", "[Processed]"))

        audio_clip = AudioFileClip(filename=mp3_path)
        silence = AudioClip(lambda t: 0, duration=1)
        audio_clip = concatenate_audioclips([silence, audio_clip])
        audio_clip.write_audiofile(filename = mp3_path.replace("[Raw]", "[New]"))
        os.remove(mp3_path)
        os.rename(mp3_path.replace("[Raw]", "[New]"), mp3_path)


# 视频合成
def create_movie(cache_path, out_path):

    print("开始制作视频")
    cache_dirlist = os.listdir(cache_path)
    images_dir = []

    # 获取需要制作的视频列表
    for cache_dir_name in cache_dirlist:
        images_dirlist = os.listdir(cache_path + "/" + cache_dir_name)
        for image_dir in images_dirlist:
            if "images" in image_dir and "[Raw]" in image_dir:
                images_dir.append(cache_path + "/" + cache_dir_name + "/" + image_dir)

    print(images_dir)

    for dir in images_dir:

        # 获取所有类型文件
        image_path = dir
        movie_path1 = dir.replace("/[Raw]images","") + "/" + "movie_without_audio&captions.mp4"
        movie_path2 = out_path + "/" + dir.replace("/[Raw]images", "").replace("./cache/", "") + ".mp4"

        all_file_path = os.listdir(dir.replace("/[Raw]images",""))
        for file_name in all_file_path:
            if ".mp3" in file_name:
                audio_path = dir.replace("/[Raw]images","") + "/" + file_name
            elif ".srt" in file_name:
                captions_path = dir.replace("/[Raw]images","") + "/" + file_name
            elif ".txt" in file_name:
                segmente_path = dir.replace("/[Raw]images","") + "/" + file_name

        # 读取音频
        audio_clip = AudioFileClip(filename = audio_path)

        # 获取图像信息的开始时间
        image_message = []
        with open(file=segmente_path, mode="r", encoding='utf8') as f:
            while True:
                line = f.readline()
                if line:
                    line = eval(line)
                    for i in range(len(line)):
                        time = time_to_seconds(line[i]['开始时间'])
                        image_message.append(time)
                else:
                    break

        # 获取音频文件的时长（以秒为单位）
        duration = audio_clip.duration
        image_message.append(duration)

        # 计算每张图片持续时间，并保存为视频
        durations = []
        for i in range(len(image_message)-1):
            durations.append(image_message[i+1] - image_message[i])
        durations[0] = durations[0] + image_message[0]

        image_clip = (ImageSequenceClip(image_path, durations=durations)).resize(width=1920, height=1080)
        image_clip.write_videofile(movie_path1, fps=2)

        # 读取视频文件
        video_clip = VideoFileClip(filename = movie_path1)
        config.change_settings({"IMAGEMAGICK_BINARY": r"D:\ImageMagick-7.1.1-Q16-HDRI\magick.exe"})

        captions = []
        with open(file=captions_path, mode="r", encoding="utf8") as f:
            for line in f:
                line = line.strip()
                if line.isdigit():
                    continue
                elif " --> " in line:
                    start, end = line.split(" --> ")
                    # start = seconds_to_hmsms(time_to_seconds(start) + 1)
                    # end = seconds_to_hmsms(time_to_seconds(end) + 1)
                elif line:
                    captions.append((start, end , line))
        txts = []
        for caption in captions:
            start_time = caption[0]
            end_time = caption[1]
            text = caption[2]

            txt = TextClip(text, fontsize=40, font="./fonts/siyuanheiti_CN_Regular.otf", color="white",
                           bg_color="black").set_start(start_time).set_end(end_time).set_position(("center", 936))
            txts.append(txt)
        video_clip = CompositeVideoClip([video_clip, *txts])

        # 添加音频到视频中
        video_clip = video_clip.set_audio(audio_clip)

        video_clip.write_videofile(movie_path2, codec="libx264", audio_codec="aac", fps=2)

        os.rename(image_path, image_path.replace("[Raw]", "[Processed]"))


