DefinitionBlock("SSDT.AML", "SSDT", 0x01, "AAEON", "PINCTRL", 0x00000001)
{
	External(\_SB_.PCI0.I2C0, DeviceObj)
    External(\_SB_.PCI0.I2C1, DeviceObj)
	External(\_SB_.GPO0, DeviceObj)

    Scope(\_SB_.PCI0.I2C1)
    {
		Device(CHIP)
		{
		    Name(_HID, "AWDZ8830")
			Name(_CID, "AWDZ8830")
    		Name(_UID, 1)

		    Method(_CRS, 0x0, NotSerialized)
		    {
		        Name(BUF1, ResourceTemplate()
		        {
					I2CSerialBusV2(0x58, ControllerInitiated, 400000, AddressingMode7Bit, "\\_SB.PCI0.I2C1", 0, ResourceConsumer, , Exclusive, )
					I2CSerialBusV2(0x5B, ControllerInitiated, 400000, AddressingMode7Bit, "\\_SB.PCI0.I2C1", 0, ResourceConsumer, , Exclusive, )
		        })

				Name(BUF2, ResourceTemplate()
		        {
					GpioIo(Exclusive, PullUp, 0x0000, 0x0000, IoRestrictionOutputOnly, "\\_SB.GPO0", 0x00, ResourceConsumer, , ) { 0x2B }
		        })

		        Return(ConcatenateResTemplate(BUF1, BUF2))
		    }

			Method(_STA, 0x00, NotSerialized)
			{
				Return(0x0F)
			}

			Method(_DSM, 0x4, Serialized)
			{
				If(LEqual(Arg0, ToUUID("1CC539CD-5A26-4288-A572-25C5744EBF1B")))
				{
					If(LEqual(Arg2, 0x0))
					{
						Return(Buffer() {0x01, 0x58, 0x01, 0x5B})
					}

					If(LEqual(Arg2, 0x1))
					{
						Return(Buffer() {0x02})
					}
				}
			}
		}
	}
}